# PS4DS_Chap3_RCode.R
# R Code for Chapter 3 of the Book "Probability and Statistics for Data Science" by Norman Matloff

##################################
# Ex: Bus Ridership
##################################

# The goal is to simulate bus ridership to estimate the expected number of passengers 
# on a bus as it departs from the tenth stop. 

# Number of repetitions (simulations)
nreps <- 10000

# Number of stops in the simulation
nstops <- 10

# Initialize the total count of passengers over all simulations
total <- 0

# Loop over all repetitions (simulations)
for (i in 1: nreps ) {
    
    # Initialize the passenger count for this particular simulation
    passengers <- 0
    
    # Loop over all bus stops in the simulation
    for (j in 1: nstops ) {
        
        # If there are any passengers on the bus
        if ( passengers > 0)
            # Loop over each passenger to check if they will depart
            for (k in 1: passengers )
                # With a 20% probability, a passenger departs
                if ( runif (1) < 0.2)
                    passengers <- passengers - 1  # Remove departed passenger
        
        # Randomly determine the number of new passengers boarding at this stop
        # Probabilities: 50% for 0 passengers, 40% for 1 passenger, and 10% for 2 passengers
        newpass <- sample (0:2 ,1 , prob =c (0.5 ,0.4 ,0.1))
        
        # Add the new passengers to the current count
        passengers <- passengers + newpass
    }
    
    # Update the total count of passengers over all simulations
    total <- total + passengers
}

# Print the average number of passengers after all simulations (expected number after 10 stops)
print ( total / nreps )

#Code without annotated comments:
nreps <- 10000
nstops <- 10
total <- 0
for (i in 1: nreps ) {
    passengers <- 0
    for (j in 1: nstops ) {
        if ( passengers > 0)
            for (k in 1: passengers )
                if ( runif (1) < 0.2)
                    passengers <- passengers - 1
        newpass <- sample (0:2 ,1 , prob =c (0.5 ,0.4 ,0.1))
        passengers <- passengers + newpass
    }
    total <- total + passengers
}

print ( total / nreps )