#S5600-6600_Approx2Bin.r

####################################################
# Setting parameters for the binomial distribution
n = 5; p = 1/5 

# Range of x-values (successes) for which the probabilities will be computed
s = 0 : 6

# Plotting the binomial pmf using vertical lines
plot(s, dbinom(s, n, p), type="h",main="Poisson(1) vs Binomial(n=5, p=1/5) pmfs",ylab="prob density") 

# Adding Poisson probabilities as points on the same graph
# The mean for the Poisson distribution is given by n*p
points(s, dpois(s, n * p), col = 2) 

# Setting parameters for the binomial distribution
n = 10; p = 1/10 

# Range remains the same
s = 0 : 6

# Plotting the binomial pmf using thicker vertical lines
plot(s, dbinom(s, n, p), type="h",lwd=4,main="Binomial(n=10, p=1/10) vs Poisson(1) pmfs",ylab="prob density") 

# Adding Poisson probabilities as red shifted lines on the same graph
lines(s+0.04, dpois(s, n * p), col='red', type='h', lwd=4) 

# Adding a legend to distinguish the two distributions
legend("topright",c("binomial","Poisson"),lty=1,col=1:2,lwd=4,inset=0.05)


####################################################
# Setting up the scenario for P(X>=85) when X follows Binomial(n=100,p=0.8)

# Calculating the exact probability using the binomial formula
x = seq(85, 100, by = 1)
prob = choose(100, x) * (.8)^x * (.2)^(100-x)
sum(prob)

# Calculating the exact probability using the "dbinom" function
(exact <- sum(dbinom(x, 100, 0.8))) # P(X>=85)

# Another method to get P(X>=85) using "pbinom"
1 - pbinom(84, 100, 0.8)

# Using the Normal approximation to approximate the binomial distribution

# Without continuity correction
n = 100; p = 0.8
mu = n * p
sd = sqrt(n * p * (1-p))
z = (85 - mu) / sd
(approx1 <- 1 - pnorm(z)) 
abs(exact - approx1) # Compute the difference between the exact and approximated values

# With continuity correction
z = (84.5 - mu) / sd 
(approx2 <- 1 - pnorm(z))
abs(exact - approx2) # The approximation error is smaller with continuity correction

# Attempting the Poisson approximation to the binomial 
lambda = n * p
(approx3 <- sum(dpois(x, lambda))) 
abs(exact - approx3) 
# This error is significantly larger, suggesting that the Poisson approximation is not a good fit here

########################################################################
# Setting up the scenario for P(X>=60) when X follows Binomial(n=100,p=0.55)

# Calculating the exact probability using the binomial formula
x = seq(60, 100, by = 1)
prob = choose(100, x) * (.55)^x * (.45)^(100-x)
sum(prob)

# Calculating the exact probability using the "dbinom" function
(exact <- sum(dbinom(x, 100, 0.55))) # P(X>=60)

# Another method to get P(X>=60) using "pbinom"
1 - pbinom(60, 100, 0.55)

# Using the Normal approximation to approximate the binomial distribution

# Without continuity correction
n = 100; p = 0.55
mu = n * p
sd = sqrt(n * p * (1-p))
z = (60 - mu) / sd
(approx1 <- 1 - pnorm(z))  # This finds the tail probability to the right of z
abs(exact - approx1) # Compute the difference between the exact and approximated values

# With continuity correction, shifting the x value by 0.5 down for approximation
z = (59.5 - mu) / sd
(approx2 <- 1 - pnorm(z)) 
abs(exact - approx2) # The approximation error is smaller with continuity correction
