# S5600-6600_AreaUnder_pdf.r
# Code to visualize the area under the probability density function (pdf) 
# of various continuous distributions, which represents the probability.

# t distribution with 74 df area between (-1.96,1.96)
# Plots the t distribution curve and shades the area between -1.96 and 1.96
curve(dt(x, 74), from = -4, to = 4, ylab="pdf", main=expression(paste(t[74], " distribution")))
x <- seq(-1.96, 1.96, len = 100)
y <- dt(x, 74)
polygon(c(x[1], x, x[100]), c(0, y, 0), col = "red", border = NA)
# Calculates the probability for the shaded region
pt(1.96, df=74) - pt(-1.96, df=74)

# standard normal distribution area between (-1.96,1.96)
# Plots the standard normal distribution curve and shades the area between -1.96 and 1.96
curve(dnorm(x), from = -4, to = 4, ylab="pdf", main="N(0,1) distribution")
x <- seq(-1.96, 1.96, len = 100)
y <- dnorm(x)
polygon(c(x[1], x, x[100]), c(0, y, 0), col = "red", border = NA)
# Calculates the probability for the shaded region
pnorm(1.96) - pnorm(-1.96)

#####################################################
# t distribution with 74 df area between (-1,1)
curve(dt(x, 74), from = -4, to = 4,ylab="pdf",main=expression(paste(t[74]," distribution")))
x <- seq(-1., 1., len = 100)
y <- dt(x, 74)
polygon(c(x[1], x, x[100]), c(0, y, 0),
        col = "red", border = NA)

pt(1,df=74) - pt(-1,df=74)
pnorm(1) - pnorm(-1)

#####################################################
# t distribution with 74 df area between (0,1)
curve(dt(x, 74), from = -4, to = 4,ylab="pdf",main=expression(paste(t[74]," distribution")))
x <- seq(0, 1., len = 100)
y <- dt(x, 74)
polygon(c(x[1], x, x[100]), c(0, y, 0),
        col = "red", border = NA)

pt(1,df=74) - pt(0,df=74)
pnorm(1) - pnorm(0)

#####################################################
# uniform distribution on (-3.9,3.9)
curve(dunif(x,-3.9,3.9), from = -4, to = 4,ylim=c(0,.15),xlim=c(-5,5),
      main="Uniform(-3.9,3.9) Distribution",ylab="pdf")
x <- seq(-1.96, 1.96, len = 100)
y <- dunif(x,-3.9,3.9)
polygon(c(x[1], x, x[100]), c(0, y, 0),
        col = "red", border = NA)

punif(1.96,-3.9,3.9)-punif(-1.96,-3.9,3.9)

#####################################################
# beta distribution with parameters 1 and 3
curve(dbeta(x,1,3), from = 0, to = 1, main="Beta(1,3) Distribution",ylab="pdf")
x <- seq(.2,.6, len = 100)
y <- dbeta(x,1,3)
polygon(c(x[1], x, x[100]), c(0, y, 0),
        col = "red", border = NA)

pbeta(.6,1,3)-pbeta(.2,1,3)

#####################################################
# exponential distribution with parameters 1 and 3
curve(dexp(x,.5), from = 0, to = 10, main="Exponential(2) Distribution",ylab="pdf")
x <- seq(2,6, len = 100)
y <- dexp(x,.5)
polygon(c(x[1], x, x[100]), c(0, y, 0),
        col = "red", border = NA)

pexp(6,.5)-pexp(2,.5)

