#S5600-6600_Inequalities_Order_Conv.r
#Demos for inequalities, the distribution of order statistics for Uniform distribution, convergence in distribution and CLT

##########################################################
#R Code to illustrate Chebychev's inequality applied to a Normal (i.e. Gaussian distribution

#Chebychev's Inequality: P(|X-mu| >= t) <= sigma^2/t^2
#For X ~ N(0,1), it becomes P(|X| >= t) <= 1/t^2

tseq<-seq(1,3,.01)

#P(X<t) = pnorm(t)
#P(X>t) = 1-pnorm(t)
true<-1-(pnorm(tseq)-pnorm(-tseq)) #This is P(|X| >= t)=1-P(|X| < t)
approx1<-1/(tseq^2) #Chebychev's Upper Bound
approx2<-sqrt(2/pi)*Exponential(-tseq^2/2)/(tseq) #Mill's Upper Bound

plot(tseq,true,xlab="t",ylab="probability", main="Normal probability: P(|X| >= t)",
     type="l",ylim=range(c(true,approx1,approx2)),lwd=T)
lines(tseq,approx1,col=2)
lines(tseq,approx2,col=3)

legend("topright",c("exact","Chebychev","Mill"),lty=1,col=1:3,inset=0.05)

##########################################################
###  Distribution of order statistics
n<-10
nreps<-10000
k<-1
y<-NULL
for (i in 1:nreps) {
  x<-runif(n,0,1)
  y[i]<-x[order(x)][k]
}

#The distribution of X_(1), which is also Beta(1,10) distribution
hist(y,freq=FALSE, main=expression(paste("Distribution of ",X[(1)])) )
t<-c(1:1000)/1000
lines(t,dbeta(t,k,n+1-k),col=2)

k<-3
y<-NULL
for (i in 1:nreps) {
  x<-runif(n,0,1)
  y[i]<-x[order(x)][k]
}

#The distribution of X_(1), which is also Beta(3,8) distribution
hist(y,freq=FALSE, main=expression(paste("Distribution of ",X[(3)])),ylim = c(0,3.1) )
t<-c(1:1000)/1000
lines(t,dbeta(t,k,n+1-k),col=2)

##########################################################
#####  Convergence in distribution
n<-100
nreps<-1000
#k<-10
y<-z<-NULL
for (i in 1:nreps) {
  x<-runif(n,0,1)
  y[i]<-max(x)  #[order(x)][k]
  z[i]<-n*(1-y[i])
}

#This is the exact distribution of X_(n), which is also Beta(n,1) distribution
hist(y,freq=FALSE, main=expression(paste("Distribution of ",X[(100)])) )
t<-c(1:1000)/1000
k<-n
lines(t,dbeta(t,k,n+1-k),col=2)

#To show limiting distribution of n(1-X_(n)) is Exponential(1) distribution
hist(z,freq=FALSE, main=expression(paste("Distribution of n(1-",X[(n)],")" )))
t<-c(1:10000)/1000
lines(t,dExponential(t,1),col=2)

##########################################################
######  Central Limit Theorem
#sample means for random samples from Exponential(1) Distribution
n<-100
nreps<-1000
xbar<-NULL
for (i in 1:nreps) {
  x<-rExponential(n,.1)
  xbar[i]<-mean(x)
}

hist(rExponential(10^3,.1),xlab="x",main="emp pdf of a Exponential(10) rv")

mu<-10
sigma2<-100
hist(sqrt(n)*(xbar-mu)/sqrt(sigma2),freq=FALSE, ylim=c(0,.45),
     xlab="standardized mean", main="emp pdf of sample mean from Exponential(1) distr")
t<-c(-300:300)/100
lines(t,dnorm(t,0,1))

##########################################################
#######  further convergence demos
n<-10000
u<-runif(n,0,1)
x<--5*(log(1-u)) #x is a random sample from Exponential(5) distribution, which is also Gamma(1,5)

z<-NULL
for (i in 1:n) {
  u<-runif(3,0,1)
  x1<--2*log(1-u) #x1 is a random sample from Exponential(2) distribution, which is also Gamma(1,2)
  z[i]<-sum(x1) #z is a vector with each entry being sum of three Gamma(1,2) r.v.s, so each entry is Gamma(3,2)
  #or equivalently Chi-Square(6) r.v.
}

y<-NULL
for (i in 1:n) {
  u<-runif(3,0,1)
  x1<--1.5*log(1-u)  #x1 is a random sample from Exponential(1.5) distribution, which is also Gamma(1,1.5)
  y[i]<-sum(x1) #y is a vector with each entry being sum of three Gamma(1,1.5) r.v.s, so each entry is Gamma(3,1.5)
}

mean(x>y) #this is an estimate of P(X>Y) where X is Exponential(5) r.v. and Y is Gamma(3,1.5) r.v.
mean(y>z) #this is an estimate of P(Y>Z) where Y is Gamma(3,1.5) r.v. and Z is Gamma(3,2) r.v.
mean(x>z) #this is an estimate of P(X>Z) where X is Exponential(5) r.v. and Z is Gamma(3,2) r.v.

mean(x) #estimate of E(X)=5
mean(y) #estimate of E(Y)=4.5
mean(z) #estimate of E(Z)=6


hist(x,freq=FALSE, main="Exponential(5) Distribution")
t<-c(1:10000)/100
lines(t,Exponential(-t/5)/5,col=2)

n<-10000
hist(z,freq=FALSE,ylim=c(0,.14), main=expression(paste("Gamma(3,2) or ",chi["6"]^"2", " Distribution")))
t<-c(1:1000)/10
lines(t,dchisq(t,df=6),col=2)
lines(t,dgamma(t,3,scale=2),col=3)
