#S5600-6600_NormalChi2.r
#R Code to generate numbers from a standard normal and also from chi-square distribution using normal

####  Drawing random samples from a standard normal distribution and checking that
####  the histogram resembles the bell shaped density
####  the empirical cdf resembles the cdf

n<-1000 #sample size

x<-rnorm(n,0,1) #random sample of size n from N(0,1) distribution
hist(x,freq=FALSE)    ## empirical density
hist(x,freq=FALSE, main="N(0,1) Distribution") ## empirical density
t<-c(-300:300)/100 
lines(t,dnorm(t,0,1)) ## true density (i.e. pdf curve)

plot(ecdf(x),main="ecdf of N(0,1) Distribution")  ## empirical cdf
lines(t,pnorm(t,0,1),col=2)    ## true cdf curve

s<-c(1:n)/n
plot(s,qnorm(s,0,1))           ## true inverse cdf
x.sort<-sort(x)
lines(s,x.sort[s*n],col=2,lwd=3)  ## empirical inverse cdf

plot(x.sort[s*n],qnorm(s,0,1),main="Q-Q plot for N(0,1) Sample")     ## QQ-plot:  true inverse cdf versus empirical inverse cdf
abline(0,1) #Q-Q plot is almost on the y=x line which is in agreement with normality

##############################################################################################
####  Drawing a random sample of size n from a chi-square distribution with 1 degree of freedom

n<-1000
x<-rchisq(n,1) #random sample of size n from chi-square distribution with df=1
hist(x,freq=FALSE, main=expression(paste(chi["1"]^"2", " Distribution"))) ## empirical density
t<-c(0:1200)/100
lines(t,dchisq(t,1)) ## true density (i.e. pdf curve)

plot(ecdf(x),main=expression(paste("ecdf of ",chi["1"]^"2", " Distribution")))  ## empirical cdf
lines(t,pchisq(t,1),col=2)  ## true cdf curve

#### Creating a chi-square distribution by squaring a standard normal random variable
z<-rnorm(n,0,1)
hist(z)
y<-z^2
hist(y,freq=FALSE,  main=expression(paste(chi["1"]^"2", " Distribution"))) ## empirical density
lines(t,dchisq(t,1)) ## true density (i.e. pdf curve)

