#S5600-6600_RandNumGen.r
#R code to generate numbers from a continuous distribution using uniformly generated numbers in (0,1),
#that is, using Probability Integral Transform

####  Probability-integral transformation: Drawing Z from N(0,1), computing Y=F_Z(Z), and showing that Y~Uniform(0,1)
n<-10000
z<-rnorm(n,0,1)
y<-pnorm(z,0,1)
hist(y,freq=FALSE,xlim=c(0,1.2),ylim = c(0,1.2))
s<-c(0:100)/100
lines(s,dunif(s,0,1),col=2)

####  Drawing from an Exponential(1) distribution
#Example 26
U<-runif(1,0,1) #U ~ Uniform(0,1)
Y<- -log(1-U) #Y ~ Exponential(1)

#Example 27, but with n=10000, instead of 50
#First generate numbers directly from Exponential(1) distribution
n<-10000
x<-rexp(n,1) #random sample of size n from Exponential(1) distribution 
hist(x,freq=FALSE, main="Exponential(1) Distribution") ## empirical density
t<-c(0:1200)/100
lines(t,dexp(t,1)) ## true density (i.e. pdf curve)

plot(ecdf(x),main="ecdf of Exponential(1) Distribution")  ## empirical cdf
lines(t,pexp(t,1),col=2) ## true cdf curve

#demo of PIT
y<-pexp(x,1)  # probability-integral transformation
hist(y,freq=FALSE,xlim=c(0,1.2),ylim = c(0,1.2))
s<-c(0:100)/100
lines(s,dunif(s,0,1),col=2)

#### Now generating U~Uniform(0,1) and creating Z~Exponential(1) 
#using inverse-probability-integral transformation
u<-runif(n,0,1)
z<-qexp(u,1)   #### Using quantile function for Exponentials
hist(z,freq=FALSE, main="Exponential(1) Distribution")
t<-c(0:1200)/100
lines(t,dexp(t,1))

z1<- -log(1-u)  #### Using direct calculations
hist(z1,freq=FALSE, main="Exponential(1) Distribution")
lines(t,dexp(t,1))

#Example: Generate 50 observations from an exponential distribution with a mean of 10 by
#using Probability Integral Transform idea. Note that the cdf of X is F_X(x,lambda) = 1 -e^{-x/lambda}
#for 0 < x < 1.

n<-50 # number of points to be generated
lambda<-10 #mean of the exponential distribution (in R parameter of exponential distribution is treated as 1/lambda)

#Generate n observations from uniform distribution on (0, 1)
y <- runif(n, 0, 1)

#From Probability Integral Transform , we know that x = F_X^{-1}(y) = -lambda log(1 - y).
# We expect x_i = -lambda ln(1 - y_i); i = 1, 2,..., 50, to represent 50 observations of an
#exponential random variable X with mean lambda That is, in R
x <- -lambda*log(1-y)             

#Then create a QQ plot to see if the generated x values have exponential distribution.
simdata <- qexp(ppoints(n), rate = 1/lambda)
qqplot(x, simdata)
abline(a=0, b=1, col = "steelblue", lwd = 2)

#or
plot(qexp(ppoints(x), rate=1/lambda), sort(x),  main="Q-Q Plot", xlab="Theoretical Quantiles", ylab="Sample Quantiles")
abline(a=0, b=1, col = "steelblue", lwd = 2)

############################
#Example: Generate 50 observations from the distribution with pdf f_X(x)=2x for 0<x<1 and 0 otherwise
#using Probability Integral Transform

n<-1000 # number of points to be generated
#Generate n observations from uniform distribution on (0; 1)
y <- runif(n, 0, 1)

# The cdf of X is F_X(x)=x^2 for 0<x<1
#From Probability Integral Transform , we know that F_X^{-1}(y) = sqrt(y).
# We expect x_i = sqrt(y_i); i = 1, 2,..., 50, to represent 50 observations of the above distribution
x <- sqrt(y)             

hist(x, freq=F)
xsq<-(1:n)/n; ysq<-2*xsq
lines(xsq,ysq)

