#S5600-6600_RBasics.r
#R Code for basics, such as, inputting, outputting, importing, exporting
#data and basic data plots and summaries

# Inputting data using the concatenation function 'c'
x<-c(66,74,79,80,69,77,78,65,79,81)

# Inputting data using the 'scan' function. No commas needed.
y<-scan(text="66 74 79 80 69 77 78 65 79 81")

# Outputting data using the 'cat' function to display without any additional format
cat(x)

# Outputting data using the 'print' function to display with additional format
print(x)

# Simply typing the variable name will also print the variable's content
x

# Importing a CSV file from the specified path into 'dataset'
dataset<-read.csv("C:/Users/ezc0066/Documents/AURelated/AUAcademic/STAT5600_6600-F2023/S5600_6600-RCode/P2-Demographic-Data.csv")

# Exporting data ('w') to a new CSV file at the specified path
w<-c(1:10)
write.csv(w,"C:/Users/ezc0066/Documents/AURelated/AUAcademic/STAT5600_6600-F2023/S5600_6600-RCode/New_data.csv") 

# Creating a stem-and-leaf plot. First, input and sort data.
X<-sort(scan(text = "78 74 82 66 94 71 64 88 55 80 91 74 82 75 96 78 84 79 71 83"))
stem(X)

# Creating a histogram. First, input and (optionally) sort data.
X<-sort(scan(text = "25 37 20 31 31 21 12 25 36 27 38 16 40 32 33 24 39 26 27 19"))
hist(X)

# Computing descriptive statistics. First, input data.
X<-scan(text="5 7 229 453 12 14 18 14 14 483 22 21 25 23 24 34 37 34 49 64 47 67 69 192 125")
summary(X)  # Display the five-number summary plus mean
sd(X)       # Compute the standard deviation
length(X)   # Find out how many data points are in 'X'

# Creating a box plot. First, input data.
X<-scan(text = "870 922 1146 1120 1079 905 888 865 1112 966 1150 977 958 1088 1139 1055 1082 1053 1048 1118 866 996 1102 1028 1130 1002 990 1052 1116 1109")
boxplot(X)

# Conducting a test of randomness on the data.
X<-scan(text = "24 31 28 43 28 56 48 39 52 32 38 49 51 49 69 33 41 58 63 56")
# Installing and loading the 'lawstat' package to conduct the runs test
install.packages("lawstat")
library("lawstat")
# Conducting the runs test to check if the data appears random
runs.test(X)
