# R code to motivate the need for the student t distribution
#Motivation for using the student-t distribution to
#obtain proper coverage of 95% intervals.

# Define true population parameters
mu    <- 1  
sigma <- 1

# Sample size and number of simulated datasets
n    <- 5   
Nsim <- 100  

# Coverage using the Normal distribution
xbar <- s <- lower <- upper <- coverN <- rep(0, Nsim)

# Set up the plot for displaying the confidence intervals
plot(NA, xlim = c(-1, 3), ylim = c(0, Nsim), xlab = "95% CI", ylab = "Dataset")
abline(v = mu)  # True mean line

# Simulate data and calculate confidence intervals using the Normal distribution
for (i in 1:Nsim) {
    Y <- rnorm(n, mu, sigma)           # Simulate sample data
    xbar[i] <- mean(Y)                 # Compute sample mean
    s[i] <- sd(Y)                      # Compute sample standard deviation
    
    # Calculate confidence intervals
    lower[i] <- xbar[i] - 1.96 * s[i] / sqrt(n)
    upper[i] <- xbar[i] + 1.96 * s[i] / sqrt(n)
    
    # Check if true mean is within the interval
    coverN[i] <- lower[i] < mu & mu < upper[i]
    
    # Plot the confidence intervals
    lines(c(lower[i], upper[i]), c(i, i), col = 2 - coverN[i])
}

# Title displaying the experimental coverage using the Normal distribution
coverageN <- round(mean(coverN), 3)
title(paste("Experimental Coverage with Z interval is ", 100 * coverageN, "%"))

# Coverage using the t-distribution
xbar <- s <- lower <- upper <- coverT <- rep(0, Nsim)

# Set up the plot again for t-distribution intervals
plot(NA, xlim = c(-1, 3), ylim = c(0, Nsim), xlab = "95% CI", ylab = "Dataset")
abline(v = mu)

# Simulate data and calculate confidence intervals using the t-distribution
for (i in 1:Nsim) {
    Y <- rnorm(n, mu, sigma)
    xbar[i] <- mean(Y)
    s[i] <- sd(Y)
    
    # Confidence intervals using t-distribution
    lower[i] <- xbar[i] - qt(.975, df = n-1) * s[i] / sqrt(n)
    upper[i] <- xbar[i] + qt(.975, df = n-1) * s[i] / sqrt(n)
    
    # Check if true mean lies within the t-interval
    coverT[i] <- lower[i] < mu & mu < upper[i]
    
    # Plot the t-distribution intervals
    lines(c(lower[i], upper[i]), c(i, i), col = 2 - coverT[i])
}

# Title displaying the experimental coverage using the t-distribution
coverageT <- round(mean(coverT), 3)
title(paste("Experimental Coverage with t interval is ", 100 * coverageT, "%"))
