#S5600-6600_cdfpdf.r
#R Code to compute cdf values or pdf or pmf values

#################################################
#Calculating discrete probabilities; 
#X is a random variable with the following distribution

X<-c(1,4,5,8,11)    
p<-c(0.2,0.2,0.1,0.15,0.35)
plot(X,p,type="h",main="pmf of X")

# Find P(X<=4)
P<-sum(p[which(X<=4)])
P

# Calculating Expected value and Variance
EX<-sum(X*p) #E(X)=sum(X*p)
VarX<-sum(X^2*p)-EX^2 #Var(X)=E(X^2)-(EX)^2=sum(X*X*p)-sum(X*p)^2
EX
VarX
abline(v=EX,lty=2,col=2)
text(EX,.2,"Expected Value")

#Example for pmfs and cdfs for Binomial distribution
pbinom(c(0:5),5,0.4) #This gives the CDF of X, where X ~ Bin(p=0.4,n=5)
pbinom(3,5,0.4)-pbinom(2,5,0.4) #This gives P(X=3), where X ~ Bin(p=0.4,n=5)
dbinom(3,5,.4)
qbinom(0.5,5,0.4)

#Example for the Binomial experiment
1-pbinom(3,18,0.05) #This gives P(X>=4), where X ~ Bin(p=0.05,n=18)

#Example for the Binomial experiment
pbinom(335,500,0.65) #This gives P(X<=335), where X ~ Bin(p=0.65,n=500)
1-pbinom(320,500,0.65) #This gives P(X>320), where X ~ Bin(p=0.65,n=500)
pbinom(300,500,0.65)-pbinom(299,500,0.65) #This gives P(X=300), where X ~ Bin(p=0.65,n=500)
pbinom(349,500,0.65)-pbinom(300,500,0.65) #This gives P(300<X<350), where X ~ Bin(p=0.65,n=500)

#################################################
#For Poisson probabilities
# To get the cumulative probability, the syntax is: ppois(x, lambda) 
# where lambda and x are values that you fill in 

# Example 1 on the Poisson:
# X is Poisson with lambda=1.
# P(X <= 1):
ppois(1, lambda=1)

# P(X >= 3) = 1 - P(X <= 2)
1 - ppois(2, lambda=1)

# P(X=2) = P(X <=2) - P(X<=1):
ppois(2, lambda=1) - ppois(1, lambda=1)
# or simply:
dpois(2, lambda=1)

# Example 2 on the Poisson:
# X is Poisson with lambda=6.

# P(X >= 5) = 1 - P(X <= 4):
1 - ppois(4, lambda=6)

# P(X <= 9) - P(X<=6):
ppois(9, lambda=6) - ppois(6, lambda=6)

# Another example:
# Suppose our random variable X is Poisson with lambda = 12.33. 
# Let's answer the following questions 
# 1. What is the probability of 15 or fewer occurrences?  P(X <= 15) 
ppois(15, lambda=12.33)

# 2. What is the probability of EXACTLY 6 successes? P(X = 6) 
ppois(6, lambda=12.33) - ppois(5, lambda=12.33)
# or simply:
dpois(6, lambda=12.33)

# 3. What is the probability of more than 13 successes? P(X > 13) 
1 - ppois(13, lambda=12.33)

# 4. What is the probability of 13 or more successes? P(X >= 13) 
1 - ppois(12, lambda=12.33)

# 5. What is the probability of 8, 9, or 10 successes? P(8 <= X <= 10) 
ppois(10, lambda=12.33) - ppois(7, lambda=12.33)

# This R program will give us the answers to all these questions in an instant.

#################################################
#For normal probabilities
# Examples of finding normal probabilities in R
# The command pnorm computes normal probabilities 

# It computes the probability that a standard normal r.v. Z is less than (or equal to) 
# a certain value.  So R gives us P(Z < value), whereas Table II in the book gives 
# us P(0 < Z < value) 

# Suppose our random variable Z is standard normal 
# Let's answer the following questions: 
# 1. What is the probability Z is between 0 and 1.24? 
pnorm(1.24) - pnorm(0)

# 2. What is the probability Z is greater than 1.24?  
1 - pnorm(1.24)

# 3. What is the probability Z is less than 1.24?  
pnorm(1.24)

# 4. What is the probability Z is between -0.54 and 0? 
pnorm(0) - pnorm(-0.54)

# 5. What is the probability Z is less than -0.54? 
pnorm(-0.54)

# 6. What is the probability Z is between -1.75 and -0.79? 
pnorm(-0.79) - pnorm(-1.75)

# 7. What is the probability Z is between -0.79 and 1.16? 
pnorm(1.16) - pnorm(-0.79)

#  What if X is normal with mean 266 and standard deviation 16 (like the pregnancy 
# example in class)?  If you're clever, you can let R standardize for you, 
# as the eighth example here will show: 

# What is the probability X is between 260 and 280? 
pnorm((280-266)/16) - pnorm((260-266)/16)

# or alternatively:
pnorm(280,mean=266,sd=16) - pnorm(260,mean=266,sd=16)

# Compare to the results using the table
# The difference is: R can do these for any value of Z 

pnorm(4.2,4,2) #This gives P(X<=4.2), where X ~ Norm(mean=4,std=2)
qnorm(0.5,4,2) #This gives median

pnorm(1.2) #This gives P(Z<=1.2), where Z ~ Norm(mean=0,std=1) (i.e. standard normal)

