# S5_6600_S3_RCode.R
# R code for generating plots and examples as used in STAT 5600/6600 Lecture Slides 3a

###########################
# Example: Plotting the Binomial cumulative distribution function (cdf)
###########################
# Load the ggplot2 package
library(ggplot2)

# Create a sample dataframe to set upper and lower x-axis limits
sample_limit<- data.frame(x = c(0, 10))

# Plot the binomial cdf for a binomial distribution with size=3 and prob=1/2
plot(pbinom(q=0:3,size=3,prob=1/2),0:3,type="s")

# Define a function to represent the Binomial cdf for ggplot
cumlfun <- function(x){pbinom(x,size=3,prob=1/2)}

# Use ggplot to draw the CDF plot with specified x-axis limits and labels
ggplot(data=data.frame(x=c(-1, 4)),aes(x)) + 
    ylab("cumulative distribution") + 
    xlab("outcome") + 
    stat_function(fun=cumlfun)

###########################
# Example: Plotting the Logistic cumulative distribution function (cdf)
###########################
# Define a custom function for the logistic cdf
logistic.cdf <- function(x) {                        
    1/(1+exp(-x))
}

# Plot the curve for the logistic cdf with specified x-axis limits, y-axis limits, and main title
curve(logistic.cdf, from = - 7.5, to = 7.5, ylim=c(0,1.1),
      main="cdf of logistic distribution",ylab="F(x)")
# Add a vertical line at x=0, with color 2 and line type 2
abline(v=0,col=2,lty=2)
# Add horizontal lines at y=0 and y=1, with color 3 and line type 3
abline(h=c(0,1),col=3,lty=3)
