import numpy as np

##################################
# Ex: Bus Ridership
##################################

# The goal is to simulate bus ridership to estimate the expected number of passengers 
# on a bus as it departs from the tenth stop. 

# Number of repetitions (simulations)
nreps = 10000

# Number of stops in the simulation
nstops = 10

# Initialize the total count of passengers over all simulations
total = 0

# Loop over all repetitions (simulations)
for i in range(nreps):
    
    # Initialize the passenger count for this particular simulation
    passengers = 0
    
    # Loop over all bus stops in the simulation
    for j in range(nstops):
        
        # If there are any passengers on the bus
        if passengers > 0:
            # Loop over each passenger to check if they will depart
            for k in range(passengers):
                # With a 20% probability, a passenger departs
                if np.random.rand() < 0.2:
                    passengers -= 1  # Remove departed passenger
        
        # Randomly determine the number of new passengers boarding at this stop
        # Probabilities: 50% for 0 passengers, 40% for 1 passenger, and 10% for 2 passengers
        newpass = np.random.choice([0, 1, 2], p=[0.5, 0.4, 0.1])
        
        # Add the new passengers to the current count
        passengers += newpass
    
    # Update the total count of passengers over all simulations
    total += passengers

# Print the average number of passengers after all simulations (expected number after 10 stops)
print(total / nreps)
