import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import t, norm
from scipy.stats import t, norm, uniform, beta, expon

# t distribution with 74 df area between (-1.96,1.96)
x = np.linspace(-4, 4, 1000)
y = t.pdf(x, df=74)
plt.plot(x, y, label=r'$t_{74}$ distribution')

x_fill = np.linspace(-1.96, 1.96, 100)
y_fill = t.pdf(x_fill, df=74)
plt.fill_between(x_fill, y_fill, color="red", alpha=0.5)

# Calculates the probability for the shaded region
probability_t = t.cdf(1.96, df=74) - t.cdf(-1.96, df=74)
print(f"Probability for t-distribution: {probability_t:.4f}")

plt.title(r'$t_{74}$ distribution')
plt.ylabel('pdf')
plt.show()

plt.clf() # Clear the previous plot

#####################################################
# standard normal distribution area between (-1.96,1.96)
x = np.linspace(-4, 4, 1000)
y = norm.pdf(x)
plt.plot(x, y, label='N(0,1) distribution')

x_fill = np.linspace(-1.96, 1.96, 100)
y_fill = norm.pdf(x_fill)
plt.fill_between(x_fill, y_fill, color="red", alpha=0.5)

# Calculates the probability for the shaded region
probability_norm = norm.cdf(1.96) - norm.cdf(-1.96)
print(f"Probability for standard normal distribution: {probability_norm:.4f}")

plt.title('N(0,1) distribution')
plt.ylabel('pdf')
plt.show()

plt.clf()

#####################################################
# t distribution with 74 df area between (-1,1)
x = np.linspace(-4, 4, 1000)
y = t.pdf(x, df=74)
plt.plot(x, y, label=r'$t_{74}$ distribution')

x_fill = np.linspace(-1, 1, 100)
y_fill = t.pdf(x_fill, df=74)
plt.fill_between(x_fill, y_fill, color="red", alpha=0.5)
plt.title(r'$t_{74}$ distribution between (-1,1)')
plt.ylabel('pdf')
plt.show()

print(t.cdf(1, df=74) - t.cdf(-1, df=74))
print(norm.cdf(1) - norm.cdf(-1))

plt.clf()

#####################################################
# t distribution with 74 df area between (0,1)
x = np.linspace(-4, 4, 1000)
y = t.pdf(x, df=74)
plt.plot(x, y, label=r'$t_{74}$ distribution')

x_fill = np.linspace(0, 1, 100)
y_fill = t.pdf(x_fill, df=74)
plt.fill_between(x_fill, y_fill, color="red", alpha=0.5)
plt.title(r'$t_{74}$ distribution between (0,1)')
plt.ylabel('pdf')
plt.show()

print(t.cdf(1, df=74) - t.cdf(0, df=74))
print(norm.cdf(1) - norm.cdf(0))

plt.clf()

#####################################################
# Uniform distribution on (-3.9,3.9)
x = np.linspace(-5, 5, 1000)
y = uniform.pdf(x, loc=-3.9, scale=7.8)  # scale is b - a, where a and b are the bounds of the uniform distribution
plt.plot(x, y, label='Uniform(-3.9,3.9) Distribution')

x_fill = np.linspace(-1.96, 1.96, 100)
y_fill = uniform.pdf(x_fill, loc=-3.9, scale=7.8)
plt.fill_between(x_fill, y_fill, color="red", alpha=0.5)
plt.title('Uniform(-3.9,3.9) Distribution')
plt.ylabel('pdf')
plt.show()

print(uniform.cdf(1.96, loc=-3.9, scale=7.8) - uniform.cdf(-1.96, loc=-3.9, scale=7.8))

plt.clf()

#####################################################
# Beta distribution with parameters 1 and 3
x = np.linspace(0, 1, 1000)
y = beta.pdf(x, 1, 3)
plt.plot(x, y, label="Beta(1,3) Distribution")
plt.title("Beta(1,3) Distribution")
plt.ylabel('pdf')

x_fill = np.linspace(0.2, 0.6, 100)
y_fill = beta.pdf(x_fill, 1, 3)
plt.fill_between(x_fill, y_fill, color="red", alpha=0.5)
plt.show()

print(beta.cdf(0.6, 1, 3) - beta.cdf(0.2, 1, 3))

plt.clf()

# Exponential distribution with lambda=0.5 (or rate=2)
x = np.linspace(0, 10, 1000)
y = expon.pdf(x, scale=2)  # scale parameter is 1/lambda
plt.plot(x, y, label="Exponential(2) Distribution")
plt.title("Exponential(2) Distribution")
plt.ylabel('pdf')

x_fill = np.linspace(2, 6, 100)
y_fill = expon.pdf(x_fill, scale=2)
plt.fill_between(x_fill, y_fill, color="red", alpha=0.5)
plt.show()

print(expon.cdf(6, scale=2) - expon.cdf(2, scale=2))

