import math
import numpy as np
import matplotlib.pyplot as plt

# Define the number of students
n = 24

# Calculate the number of possible ways to assign birthdays to 24 students
ways_to_assign_birthdays = 365**n
print(ways_to_assign_birthdays)

# Calculate the exact probability that all birthdays are unique
# Using math.comb(365, n) to get combinations and math.factorial(n) to get factorial of n
PAc = math.factorial(n) * math.comb(365, n) / (365**n)
print(PAc)

# Compute the exact probability that at least two students share a birthday
PA = 1 - PAc
print(PA)

######################################################
# Empirical Estimation using Monte Carlo Simulations
# Define the number of simulations
Nsim = 10000

# Initialize a list to record results of simulations
all_diff_bday = []

# Run simulations to check if all birthdays are unique
for i in range(Nsim):
    b_days = np.random.choice(365, n, replace=True)  # Sample `n` birthdays from 365 days
    all_diff_bday.append(len(np.unique(b_days)) == n)

# Calculate the empirical probability that all birthdays are unique
prob_all_unique = np.mean(all_diff_bday)
print(prob_all_unique)

# Calculate the empirical probability that at least two students share a birthday
print(1 - prob_all_unique)

######################################################
# Shortened Empirical Estimation
Nsim = 10000
n = 24  # Assuming you have defined the number of students as 24, as in the previous code
cnt = 0

for i in range(Nsim):
    unique_birthdays = len(np.unique(np.random.choice(365, n, replace=True)))
    if unique_birthdays == n:
        cnt += 1

prob_all_unique = cnt / Nsim
print(prob_all_unique)

prob_shared_birthday = 1 - prob_all_unique
print(prob_shared_birthday)

######################################################
# One-liner Empirical Estimation in R but longer in Python
def any_duplicated(x):
    return len(x) != len(np.unique(x))

Nsim = 10000
n = 24  # Assuming you have defined the number of students as 24, as in the previous code

samples = np.random.choice(365, (Nsim, n), replace=True)
duplicates = np.apply_along_axis(any_duplicated, 1, samples)

PAc = np.mean(~duplicates)
print(PAc)

print(1 - PAc)

######################################################
# Plotting the Results
def factorial_choose(n, k):
    # Calculates n! / (k! * (n-k)!)
    return math.factorial(n) / (math.factorial(k) * math.factorial(n - k))

# Define the number of simulations
Nsim = 10000

# Calculate the exact probabilities for varying number of students
nseq = range(2, 82)
PA_seq = []

for i in nseq:
    PAc = math.factorial(i) / (365**i) * math.comb(365, i)
    PA_seq.append(1 - PAc)
    
# Output result
#print(PA_seq)

# Calculate empirical probabilities for varying number of students
PA_sim = []

for i in nseq:
    cnt = 0
    for j in range(Nsim):
        cnt += 1 if len(set([random.randint(1, 365) for _ in range(i)])) == i else 0
    PA_sim.append(1 - cnt / Nsim)

# Output result
#print(PA_sim)

# Plot the probabilities
plt.plot(nseq, PA_seq, color="red", linestyle="-", label="exact")
plt.plot(nseq, PA_sim, color="blue", linestyle="-", label="empirical")

plt.xlabel("n")
plt.ylabel("P(A)")
plt.title("Probability of Birthday Sharing")
plt.legend(loc="lower right", fontsize=12)
plt.show()



