import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import norm, chi2

####  Drawing random samples from a standard normal distribution and checking that
####  the histogram resembles the bell shaped density
####  the empirical cdf resembles the cdf
n = 1000  # sample size
x = np.random.normal(0, 1, n)  # random sample of size n from N(0,1) distribution

# Empirical density with true density (i.e. pdf curve)
plt.hist(x, bins=30, density=True, label="Empirical Density")
t = np.linspace(-3, 3, 600)
plt.plot(t, norm.pdf(t, 0, 1), label="True Density")
plt.title("N(0,1) Distribution")
plt.legend()
plt.show()

plt.clf()

# Empirical cdf with true cdf
plt.plot(t, norm.cdf(t, 0, 1), label="True CDF")
plt.plot(np.sort(x), np.arange(1, n + 1) / n, label="Empirical CDF")
plt.title("ecdf of N(0,1) Distribution")
plt.legend()
plt.show()

plt.clf()

# True inverse cdf versus empirical inverse cdf
s = np.arange(1, n + 1) / n
plt.plot(s, norm.ppf(s, 0, 1), label="True Inverse CDF")
x_sort = np.sort(x)
plt.plot(s, x_sort, label="Empirical Inverse CDF", color="red", linewidth=2)
plt.title("Inverse CDF plot")
plt.legend()
plt.show()

plt.clf()

# QQ-plot: true inverse cdf versus empirical inverse cdf
plt.scatter(x_sort, norm.ppf(s, 0, 1))
plt.plot([-3, 3], [-3, 3], 'k-')  # y=x line
plt.title("Q-Q plot for N(0,1) Sample")
plt.xlabel("Empirical Quantiles")
plt.ylabel("Theoretical Quantiles")
plt.grid(True)
plt.show()

plt.clf()

##############################################################################################
####  Drawing a random sample of size n from a chi-square distribution with 1 degree of freedom

n = 1000

# Random sample of size n from chi-square distribution with df=1
x = np.random.chisquare(1, n)

# Empirical density with true density (i.e. pdf curve)
plt.hist(x, bins=30, density=True, label="Empirical Density")
t = np.linspace(0, 12, 1200)
plt.plot(t, chi2.pdf(t, 1), label="True Density")
plt.title(r"$\chi^2_1$ Distribution")
plt.legend()
plt.show()

plt.clf()

# Empirical cdf with true cdf
plt.plot(t, chi2.cdf(t, 1), label="True CDF")
plt.plot(np.sort(x), np.arange(1, n + 1) / n, label="Empirical CDF")
plt.title(r"ecdf of $\chi^2_1$ Distribution")
plt.legend()
plt.show()

plt.clf()

# Creating a chi-square distribution by squaring a standard normal random variable
z = np.random.normal(0, 1, n)
plt.hist(z, bins=30)
plt.title("Histogram of Standard Normal Random Variable")
plt.show()

plt.clf()

y = z**2
plt.hist(y, bins=30, density=True, label="Empirical Density")
plt.plot(t, chi2.pdf(t, 1), label="True Density")
plt.title(r"$\chi^2_1$ Distribution")
plt.legend()
plt.show()
