import pandas as pd
import matplotlib.pyplot as plt
import numpy as np
from scipy import stats

# Inputting data using Python's list
x = [66,74,79,80,69,77,78,65,79,81]

# Same data as before for y
y = list(map(int, "66 74 79 80 69 77 78 65 79 81".split()))

# Outputting data in Python
print(x)  # Similar to cat(x)
print(x)  # Similar to print(x)

# Importing a CSV file from the specified path into 'dataset'
dataset = pd.read_csv("C:/Users/ezc0066/OneDrive - Auburn University/Documents/AURelated/AUAcademic/STAT5600_6600-F2023/STAT5600_6600-RCode/P2-Demographic-Data.csv")

# Exporting data ('w') to a new CSV file at the specified path
w = list(range(1, 11))
w_df = pd.DataFrame(w)
w_df.to_csv("C:/Users/ezc0066/OneDrive - Auburn University/Documents/AURelated/AUAcademic/STAT5600_6600-F2023/STAT5600_6600-PyCode/New_data.csv", index=False, header=False)

# Stem-and-leaf plot isn't directly supported in Python's main libraries. You might need specialized libraries or custom code for this.
# Alternatively, you could visualize data with histograms or other plots.

# Creating a histogram
X = sorted([25, 37, 20, 31, 31, 21, 12, 25, 36, 27, 38, 16, 40, 32, 33, 24, 39, 26, 27, 19])
plt.hist(X)
plt.show()

plt.clf()

# Computing descriptive statistics
X = [5, 7, 229, 453, 12, 14, 18, 14, 14, 483, 22, 21, 25, 23, 24, 34, 37, 34, 49, 64, 47, 67, 69, 192, 125]
print("Descriptive Statistics:")
print("Min:", np.min(X))
print("1st Quartile:", np.percentile(X, 25))
print("Median:", np.median(X))
print("Mean:", np.mean(X))
print("3rd Quartile:", np.percentile(X, 75))
print("Max:", np.max(X))
print("Standard Deviation:", np.std(X))
print("Length:", len(X))

# Creating a box plot
X = [870, 922, 1146, 1120, 1079, 905, 888, 865, 1112, 966, 1150, 977, 958, 1088, 1139, 1055, 1082, 1053, 1048, 1118, 866, 996, 1102, 1028, 1130, 1002, 990, 1052, 1116, 1109]
plt.boxplot(X)
plt.show()

plt.clf()

# Conducting a test of randomness on the data.
# Python doesn't have an exact equivalent of the runs.test() from the lawstat R package.
# You might need to find specialized packages or implement a custom solution as follows

from scipy.stats import norm

def runs_test(x, alpha=0.05):
    """
    Performs the Wald-Wolfowitz Runs Test for randomness.
    """
    # Create a binary sequence where 1 if x[i] >= mean(x) else 0
    mean_x = x.mean()
    bits = (x >= mean_x).astype(int)
    
    # Calculate the number of runs
    n_runs = 1 + sum(bits[:-1] != bits[1:])
    
    # Calculate the expected value and variance of the number of runs
    n1 = sum(bits)
    n2 = len(bits) - n1
    expected_value = 2 * n1 * n2 / (n1 + n2) + 1
    variance = (expected_value - 1) * (expected_value - 2) / (n1 + n2 - 1)
    
    # Calculate the z statistic
    z = (n_runs - expected_value) / (variance**0.5)
    
    # Find the p-value for the z statistic
    p_value = 2 * (1 - norm.cdf(abs(z)))
    
    # Return whether we can reject the null hypothesis of randomness
    return p_value < alpha, p_value

# Example Usage:
x = np.array([24, 31, 28, 43, 28, 56, 48, 39, 52, 32, 38, 49, 51, 49, 69, 33, 41, 58, 63, 56])
result, p_value = runs_test(x)
print(f"Reject the null hypothesis of randomness: {result}, p-value: {p_value:.4f}")

