import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import norm, uniform, expon

#Python code to generate numbers from a continuous distribution using uniformly generated numbers in (0,1),
#that is, using Probability Integral Transform

####  Probability-integral transformation: Drawing Z from N(0,1), computing Y=F_Z(Z), and showing that Y~Uniform(0,1)
n = 10000

# Drawing Z from N(0,1)
z = np.random.normal(0, 1, n)

# Computing Y=F_Z(Z)
y = norm.cdf(z, 0, 1)

# Plotting the histogram and the uniform density
plt.hist(y, bins=30, density=True, range=(-0.2, 1.2), label="Empirical Density")
s = np.linspace(0, 1, 100)
plt.plot(s, uniform.pdf(s, 0, 1), label="Uniform Density", color='red')
plt.xlim(-0.2, 1.2)
plt.ylim(0, 1.2)
plt.legend()
plt.show()

plt.clf()

####  Drawing from an Exponential(1) distribution
#Example 26
# U ~ Uniform(0,1)
U = np.random.uniform(0, 1)

#Example 27, but with n=10000, instead of 50
#First generate numbers directly from Exponential(1) distribution

# Y ~ Exponential(1)
Y = -np.log(1-U)

# Generate numbers directly from Exponential(1) distribution
n = 10000

x = np.random.exponential(scale=1, size=n)

# Plotting the histogram and the exponential density
plt.figure(figsize=(10, 5))

plt.subplot(1, 2, 1)
plt.hist(x, bins=30, density=True, label="Empirical Density")
t = np.linspace(0, 12, 100)
plt.plot(t, expon.pdf(t), label="Exponential Density", color='red')
plt.title("Exponential(1) Distribution")
plt.legend()

plt.subplot(1, 2, 2)
plt.plot(t, expon.cdf(t), label="Exponential CDF", color='red')
plt.step(np.sort(x), np.arange(1, n+1)/n, label="Empirical CDF")
plt.title("ecdf of Exponential(1) Distribution")
plt.legend()

plt.tight_layout()
plt.show()

plt.clf()

#demo of PIT
y = expon.cdf(x)

# Plotting the histogram and the uniform density
plt.hist(y, bins=30, density=True, range=(0, 1.2), label="Empirical Density")
s = np.linspace(0, 1, 100)
plt.plot(s, uniform.pdf(s), label="Uniform Density", color='red')
plt.xlim(-0.2, 1.2)
plt.ylim(0, 1.2)
plt.legend()
plt.show()

plt.clf()

#### Now generating U~Uniform(0,1) and creating Z~Exponential(1) using
#inverse-probability-integral transformation
n = 10000  # Assuming n = 10000 as in the previous examples
u = np.random.uniform(0, 1, n)

# Using the quantile function for Exponentials
z = expon.ppf(u)

# Plotting the Exponential(1) Distribution using quantile function
plt.hist(z, bins=30, density=True, label="Using quantile function", alpha=0.5)
t = np.linspace(0, 12, 100)
plt.plot(t, expon.pdf(t), color='red')
plt.title("Exponential(1) Distribution")
plt.legend()
plt.show()

plt.clf()

# Using direct calculations
z1 = -np.log(1 - u)

# Plotting the Exponential(1) Distribution using direct calculations
plt.hist(z1, bins=30, density=True, label="Using direct calculations", alpha=0.5)
plt.plot(t, expon.pdf(t), color='red')
plt.title("Exponential(1) Distribution")
plt.legend()
plt.show()

plt.clf()

#Example: Generate 50 observations from an exponential distribution with a mean of 10 by
#using Probability Integral Transform idea. Note that the cdf of X is F_X(x,lambda) = 1 -e^{-x/lambda}
#for 0 < x < 1.

n = 50  # number of points to be generated
lambda_ = 10  # mean of the exponential distribution

# Generate n observations from uniform distribution on (0, 1)
y = np.random.uniform(0, 1, n)

# From Probability Integral Transform, generate exponential values
x = -lambda_ * np.log(1 - y)

# Create a QQ plot to see if the generated x values have exponential distribution
simdata = expon.ppf(np.linspace(0, 1, n), scale=lambda_)

plt.figure(figsize=(10, 5))
plt.subplot(1, 2, 1)
plt.scatter(simdata, np.sort(x))
plt.plot([0, max(simdata)], [0, max(simdata)], color='steelblue', lw=2)
plt.title("QQ Plot")
plt.xlabel("Theoretical Quantiles")
plt.ylabel("Sample Quantiles")

plt.subplot(1, 2, 2)
plt.scatter(expon.ppf(np.linspace(1/(2*n), 1-1/(2*n), n), scale=lambda_), np.sort(x))
plt.plot([0, max(simdata)], [0, max(simdata)], color='steelblue', lw=2)
plt.title("QQ Plot")
plt.xlabel("Theoretical Quantiles")
plt.ylabel("Sample Quantiles")

plt.tight_layout()
plt.show()

plt.clf()

############################
#Example: Generate 50 observations from the distribution with pdf f_X(x)=2x for 0<x<1 and 0 otherwise
#using Probability Integral Transform
n = 1000  # number of points to be generated

# Generate n observations from uniform distribution on (0, 1)
y = np.random.uniform(0, 1, n)

# From Probability Integral Transform, generate x values using inverse CDF
x = np.sqrt(y)

# Plot histogram and overlay the y=2x curve
plt.hist(x, bins=30, density=True, alpha=0.6, label='Histogram of x')
xsq = np.linspace(0, 1, n)
ysq = 2 * xsq
plt.plot(xsq, ysq, label='y=2x', color='red')
plt.legend()
plt.show()

plt.clf()

