import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import binom

###########################
# Example: Plotting the Binomial cumulative distribution function (cdf)
###########################

# Plot the binomial cdf for a binomial distribution with size=3 and prob=1/2
x = np.arange(0, 4)
y = binom.cdf(x, 3, 0.5)
plt.step(x, y, where='post', label='Binomial CDF')
plt.xlim(-1, 4)
plt.ylim(0, 1)
plt.xlabel('Outcome')
plt.ylabel('Cumulative Distribution')
plt.title('Binomial CDF for size=3 and prob=1/2')
plt.grid(True)
plt.legend()
plt.show()

plt.clf()

###########################
# Example: Plotting the Logistic cumulative distribution function (cdf)
###########################
# Define a custom function for the logistic cdf
def logistic_cdf(x):
    return 1 / (1 + np.exp(-x))

# Create x values for the curve
x = np.linspace(-7.5, 7.5, 400)
y = logistic_cdf(x)

# Plot the curve for the logistic cdf
plt.plot(x, y, label='Logistic CDF')
plt.xlim(-7.5, 7.5)
plt.ylim(0, 1.1)
plt.xlabel('x')
plt.ylabel('F(x)')
plt.title('CDF of Logistic Distribution')
plt.grid(True)

# Add vertical line at x=0
plt.axvline(0, color='red', linestyle='--', label='x=0')

# Add horizontal lines at y=0 and y=1
plt.axhline(0, color='green', linestyle='--')
plt.axhline(1, color='green', linestyle='--')

plt.legend()
plt.show()

plt.clf()
