import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import binom, poisson, norm

#################################################
#Calculating discrete probabilities; 
#X is a random variable with the following distribution
X = np.array([1, 4, 5, 8, 11])
p = np.array([0.2, 0.2, 0.1, 0.15, 0.35])

# Plotting the pmf of X
plt.stem(X, p, basefmt=" ", linefmt='gray')
plt.title("pmf of X")
plt.xlabel("X")
plt.ylabel("p")
plt.show()

plt.clf()

# Find P(X <= 4)
P = np.sum(p[X <= 4])
print(P)

# Calculating Expected value and Variance
EX = np.sum(X * p)  # E(X) = sum(X * p)
VarX = np.sum(X**2 * p) - EX**2  # Var(X) = E(X^2) - (E(X))^2

print(f"E(X): {EX}")
print(f"Var(X): {VarX}")

# Plotting the pmf of X with the expected value
plt.stem(X, p, basefmt=" ", linefmt='gray')
plt.axvline(x=EX, linestyle='--', color='red')
plt.text(EX, 0.2, "Expected Value", rotation=90, verticalalignment='center')
plt.title("pmf of X with Expected Value")
plt.xlabel("X")
plt.ylabel("p")
plt.show()

#Example for pmfs and cdfs for Binomial distribution
# CDF of X, where X ~ Bin(p=0.4, n=5)
print(binom.cdf(range(6), 5, 0.4))

# P(X=3), where X ~ Bin(p=0.4, n=5)
print(binom.cdf(3, 5, 0.4) - binom.cdf(2, 5, 0.4))

# Using pmf to get the same probability
print(binom.pmf(3, 5, 0.4))

# Quantile function
print(binom.ppf(0.5, 5, 0.4))

#################################################
#For Poisson probabilities
# To get the cumulative probability, the syntax is: ppois(x, lambda) 
# where lambda and x are values that you fill in 

# Example 1 on the Poisson:
# X is Poisson with lambda=1.
# P(X <= 1):
print(poisson.cdf(1, mu=1))

# P(X >= 3) = 1 - P(X <= 2)
print(1 - poisson.cdf(2, mu=1))

# P(X=2) = P(X <=2) - P(X<=1):
print(poisson.cdf(2, mu=1) - poisson.cdf(1, mu=1))

# or simply:
print(poisson.pmf(2, mu=1))

# Example 2 on the Poisson:
# X is Poisson with lambda=6.

# P(X >= 5) = 1 - P(X <= 4):
print(1 - poisson.cdf(4, mu=6))

# P(X <= 9) - P(X<=6):
print(poisson.cdf(9, mu=6) - poisson.cdf(6, mu=6))

# Another example:
# Suppose our random variable X is Poisson with lambda = 12.33. 
# Let's answer the following questions 
# 1. What is the probability of 15 or fewer occurrences?  P(X <= 15) 
# Lambda value
lambda_val = 12.33

# 1. What is the probability of 15 or fewer occurrences?  P(X <= 15) 
print(poisson.cdf(15, mu=lambda_val))

# 2. What is the probability of EXACTLY 6 successes? P(X = 6) 
print(poisson.cdf(6, mu=lambda_val) - poisson.cdf(5, mu=lambda_val))

# or simply:
print(poisson.pmf(6, mu=lambda_val))

# 3. What is the probability of more than 13 successes? P(X > 13) 
print(1 - poisson.cdf(13, mu=lambda_val))

# 4. What is the probability of 13 or more successes? P(X >= 13) 
print(1 - poisson.cdf(12, mu=lambda_val))

# 5. What is the probability of 8, 9, or 10 successes? P(8 <= X <= 10) 
print(poisson.cdf(10, mu=lambda_val) - poisson.cdf(7, mu=lambda_val))

#################################################
#For normal probabilities
# Examples of finding normal probabilities in R
# The command pnorm computes normal probabilities 

# It computes the probability that a standard normal r.v. Z is less than (or equal to) 
# a certain value.  So R gives us P(Z < value), whereas Table II in the book gives 
# us P(0 < Z < value) 

# Suppose our random variable Z is standard normal 
# Let's answer the following questions: 
# 1. What is the probability Z is between 0 and 1.24? 
print(norm.cdf(1.24) - norm.cdf(0))

# 2. What is the probability Z is greater than 1.24?  
print(1 - norm.cdf(1.24))

# 3. What is the probability Z is less than 1.24?  
print(norm.cdf(1.24))

# 4. What is the probability Z is between -0.54 and 0? 
print(norm.cdf(0) - norm.cdf(-0.54))

# 5. What is the probability Z is less than -0.54? 
print(norm.cdf(-0.54))

# 6. What is the probability Z is between -1.75 and -0.79? 
print(norm.cdf(-0.79) - norm.cdf(-1.75))

# 7. What is the probability Z is between -0.79 and 1.16? 
print(norm.cdf(1.16) - norm.cdf(-0.79))

# What is the probability X is between 260 and 280? 
mean_val = 266
std_val = 16
print(norm.cdf((280 - mean_val) / std_val) - norm.cdf((260 - mean_val) / std_val))

# or alternatively:
print(norm.cdf(280, loc=mean_val, scale=std_val) - norm.cdf(260, loc=mean_val, scale=std_val))

# pnorm(4.2,4,2) in R
print(norm.cdf(4.2, loc=4, scale=2))

# qnorm(0.5,4,2) in R
print(norm.ppf(0.5, loc=4, scale=2))

# pnorm(1.2) in R
print(norm.cdf(1.2))
