## Lecture Slides 3 & Bayes Rules! Chapter 3 R Examples 
## Enhanced for Efficiency

# Load necessary libraries
library(tidyverse)
library(bayesrules)
library(patchwork)  # For easier plot composition

# Set Working Directory to Source File Location
library("rstudioapi")  # Load rstudioapi package
setwd(dirname(getActiveDocumentContext()$path)) # Set working directory to source file location

# Plots of different beta distributions
beta_plots <- list(
  plot_beta(1, 5) + ggtitle("Beta(1,5)"),
  plot_beta(1, 2) + ggtitle("Beta(1,2)"),
  plot_beta(3, 7) + ggtitle("Beta(3,7)"),
  plot_beta(1, 1) + ggtitle("Beta(1,1)"),
  plot_beta(5, 5) + ggtitle("Beta(5,5)"),
  plot_beta(20, 20) + ggtitle("Beta(20,20)"),
  plot_beta(7, 3) + ggtitle("Beta(7,3)"),
  plot_beta(2, 1) + ggtitle("Beta(2,1)"),
  plot_beta(5, 1) + ggtitle("Beta(5,1)")
)

# Combine all beta plots using patchwork and display them in a 3-column grid
combined_plots <- beta_plots[[1]] + beta_plots[[2]] + beta_plots[[3]] +
  beta_plots[[4]] + beta_plots[[5]] + beta_plots[[6]] +
  beta_plots[[7]] + beta_plots[[8]] + beta_plots[[9]] +
  plot_layout(ncol = 3)

# Display the combined plots
combined_plots

# Plots of different beta prior choices
beta_9_11 <- plot_beta(9, 11, mean = TRUE, mode = TRUE)
beta_18_22 <- plot_beta(18, 22, mean = TRUE, mode = TRUE)
beta_45_55 <- plot_beta(45, 55, mean = TRUE, mode = TRUE)

# Display the three plots in a vertical layout
(beta_9_11 / beta_18_22 / beta_45_55)

# Comparing prior and posterior in the political candidate example
plot_beta_binomial(alpha = 45, beta = 55, y = 30, n = 50)
summarize_beta_binomial(alpha = 45, beta = 55, y = 30, n = 50)

##############################
# Credit Card Debt Example

# Beta(2,8) prior analysis
plot_beta(2, 8, mean = TRUE, mode = TRUE)
plot_beta_binomial(alpha = 2, beta = 8, y = 22, n = 115)
summarize_beta_binomial(alpha = 2, beta = 8, y = 22, n = 115)

# Beta(1,1) (Uniform) prior analysis
plot_beta_binomial(alpha = 1, beta = 1, y = 22, n = 115)
summarize_beta_binomial(alpha = 1, beta = 1, y = 22, n = 115)

########################################################
# R Code for Chapter 3 Content
########################################################

# Plot Beta(45, 55) prior
plot_beta(45, 55)

# Plot Beta-Binomial posterior for Michelle's election support
plot_beta_binomial(alpha = 45, beta = 55, y = 30, n = 50)

# Summarize prior and posterior models
summarize_beta_binomial(alpha = 45, beta = 55, y = 30, n = 50)

# Simulate posterior model of Michelle’s support π
set.seed(84735)
michelle_sim <- tibble(pi = rbeta(10000, 45, 55)) %>%
  mutate(y = rbinom(10000, size = 50, prob = pi))

# Plot simulated pairs of π and y
ggplot(michelle_sim, aes(x = pi, y = y)) +
  geom_point(aes(color = (y == 30)), size = 0.1)

# Filter and plot posterior density of π
michelle_post <- michelle_sim %>%
  filter(y == 30)

ggplot(michelle_post, aes(x = pi)) +
  geom_density()

# Summarize simulated posterior model
michelle_post %>%
  summarize(mean_pi = mean(pi), sd_pi = sd(pi))

# Summarize psychologist’s prior and posterior models for π
summarize_beta_binomial(alpha = 1, beta = 10, y = 26, n = 40)

# Plot Beta prior, scaled likelihood, and Beta posterior for the psychologist's analysis
plot_beta_binomial(alpha = 1, beta = 10, y = 26, n = 40)

