## Lecture Slides 4 & Bayes Rules! Chapter 4 R Examples 
## Enhanced for Efficiency

# Load required libraries
library(bayesrules)
library(tidyverse)
library(janitor)
library(patchwork)  # For easier plot composition

# Bechdel test example:
# Plots of different beta prior distributions
beta_5_11 <- plot_beta(5, 11) + ggtitle("Beta(5,11)")
beta_1_1 <- plot_beta(1, 1) + ggtitle("Beta(1,1)")
beta_14_1 <- plot_beta(14, 1) + ggtitle("Beta(14,1)")

# Display the three plots in a vertical layout
(beta_5_11 / beta_1_1 / beta_14_1)

# Import data
data(bechdel, package = "bayesrules")

# Take a sample of 20 movies
set.seed(84735)
bechdel_sam <- bechdel %>% 
  sample_n(20)

# Show the first 3 rows of our sample
bechdel_sam %>% 
  head(3)

# Table of passes and fails for the sample of 20 movies
bechdel_sam %>% 
  tabyl(binary) %>% 
  adorn_totals("row")

# Plotting the posteriors corresponding to each prior
beta_post_14_22 <- plot_beta(14, 22) + ggtitle("Beta(14,22)")
beta_post_10_12 <- plot_beta(10, 12) + ggtitle("Beta(10,12)")
beta_post_23_12 <- plot_beta(23, 12) + ggtitle("Beta(23,12)")

# Display the posterior plots in a vertical layout
(beta_post_14_22 / beta_post_10_12 / beta_post_23_12)

# Visualizing how the prior and likelihood combine to create the posterior for each prior choice
pri_like_5_11 <- plot_beta_binomial(alpha = 5, beta = 11, y = 9, n = 20) + ggtitle("Beta(5,11) prior")
pri_like_1_1 <- plot_beta_binomial(alpha = 1, beta = 1, y = 9, n = 20) + ggtitle("Beta(1,1) prior")
pri_like_14_1 <- plot_beta_binomial(alpha = 14, beta = 1, y = 9, n = 20) + ggtitle("Beta(14,1) prior")

# Display the prior-likelihood combinations in a vertical layout
(pri_like_5_11 / pri_like_1_1 / pri_like_14_1)

# Visualizing prior and likelihood for three different sample sizes with Beta(14,1) prior
small_sam <- plot_beta_binomial(alpha = 14, beta = 1, y = 6, n = 13) + ggtitle("Small sample")
large_sam <- plot_beta_binomial(alpha = 14, beta = 1, y = 29, n = 63) + ggtitle("Large sample")
very_large_sam <- plot_beta_binomial(alpha = 14, beta = 1, y = 46, n = 99) + ggtitle("Very Large sample")

# Display the sample size comparison in a vertical layout
(small_sam / large_sam / very_large_sam)

# Plot of Beta(10,90) prior
plot_beta(10, 90) + ggtitle("Beta(10,90)")

# Pessimistic prior overwhelmed by a LARGE amount of data
plot_beta_binomial(alpha = 10, beta = 90, y = 900, n = 1000)

# Posterior summary for this example
summarize_beta_binomial(alpha = 10, beta = 90, y = 900, n = 1000)

