###############################
# Prior Elicitation Example #
###############################

#################################
### Example (Mobile Device Use Data)
### Hypothetical Data
#################################

## The variable of interest is the number of hours per week 
## that college-age students spend on Internet-connected mobile devices 
## (smartphones, tablets, etc.) in the US.

# The parameter of interest is the mean weekly number of hours.

# We will use a normal prior for this parameter.

# Suppose 5 experts named the most likely value for this weekly mean
# and also gave two numbers in between which they were 
# 80% sure the mean fell (i.e., the 0.1 and 0.9 quantiles).

N_exp = 5

# Create a data frame to store the expert data
# column 1 is for expert 1, column 2 is for expert 2, etc.
expert_data <- data.frame(
  median = c(18, 20, 22, 19, 21),
  quant_0.1 = c(12, 15, 16, 14, 17),
  quant_0.9 = c(24, 25, 28, 24, 27)
)

# Combine the expert data into a single vector
expert_quants <- c(expert_data$median, expert_data$quant_0.1, expert_data$quant_0.9)

# Generate corresponding z-values for the quantiles (0.5, 0.1, and 0.9)
z_quants <- rep(c(qnorm(0.5), qnorm(0.1), qnorm(0.9)), each = N_exp)

# Fit the linear model to estimate the prior mean (intercept) and standard deviation (slope)
fit <- lm(expert_quants ~ z_quants)

# Output the coefficients
coef(fit)

# We use the estimated intercept as the prior mean and the estimated slope
# as the prior standard deviation.

####################################################################
####################################################################
#################################
### Example (Mobile Device Use Data)
### Data Obtained from Experts in Class
#################################
N_exp = 
# Create a data frame to store the expert data
# column 1 is for expert 1, column 2 is for expert 2, etc.
expert_data <- data.frame(
  median = c(),
  quant_0.1 = c(),
  quant_0.9 = c()
)

# Combine the expert data into a single vector
expert_quants <- c(expert_data$median, expert_data$quant_0.1, expert_data$quant_0.9)

# Generate corresponding z-values for the quantiles (0.5, 0.1, and 0.9)
z_quants <- rep(c(qnorm(0.5), qnorm(0.1), qnorm(0.9)), each = N_exp)

# Fit the linear model to estimate the prior mean (intercept) and standard deviation (slope)
fit <- lm(expert_quants ~ z_quants)

# Output the coefficients
coef(fit)

# We use the estimated intercept as the prior mean and the estimated slope
# as the prior standard deviation.
